<?php
/**
 * @package         Articles Field
 * @version         4.4.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

use Bluecoder\Component\Jfilters\Administrator\Model\Filter\Option\Collection as JfiltersCollection;
use Joomla\CMS\Language\Text as JText;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Extension as RL_Extension;
use RegularLabs\Library\FieldsPlugin;
use RegularLabs\Plugin\Fields\Articles\Helper;

defined('_JEXEC') or die;

if ( ! is_file(JPATH_LIBRARIES . '/regularlabs/regularlabs.xml')
    || ! class_exists('RegularLabs\Library\Parameters')
    || ! class_exists('RegularLabs\Library\DownloadKey')
    || ! class_exists('RegularLabs\Library\FieldsPlugin')
)
{
    return;
}

if ( ! RL_Document::isJoomlaVersion(4))
{
    RL_Extension::disable('articles', 'plugin', 'fields');

    RL_Document::adminError(
        JText::sprintf('RL_PLUGIN_HAS_BEEN_DISABLED', JText::_('ARTICLESFIELD'))
    );

    return;
}

if (true)
{
    class PlgFieldsArticles extends FieldsPlugin
    {
        /**
         * Prepares the field value.
         *
         * @param   string $context The context.
         * @param stdclass $item    The item.
         * @param stdclass $field   The field.
         *
         * @return  string
         *
         * @since   3.7.0
         */
        public function onCustomFieldsPrepareField($context, $item, $field)
        {
            // Check if the field should be processed by us
            if (!$this->isTypeSupported($field->type)) {
                return;
            }

            // The field's rawvalue should be an array
            if (!is_array($field->rawvalue)) {
                $field->rawvalue = (array) $field->rawvalue;
            }

            return parent::onCustomFieldsPrepareField($context, $item, $field);
        }

        public function onJFiltersOptionsAfterCreation(JfiltersCollection $options)
        {
            $attributes = $options->getFilterItem()->getAttributes();

            if ($attributes->get('type') !== $this->_name)
            {
                return $options;
            }

            $sort_by        = $attributes->get('options_sort_by', 'title');
            $sort_direction = strtoupper($attributes->get('options_sort_direction', 'ASC'));
            $options_by_id  = [];

            foreach ($options as $option)
            {
                $label = $option->getLabel();

                $options_by_id[$label] = $option;
            }

            $ids = array_keys($options_by_id);

            $articles = Helper::getArticlesByIds($ids);

            $this->orderArticles($articles, $sort_by, $sort_direction, $options_by_id);

            $options->clearItems(false);

            foreach ($articles as $article)
            {
                $option = $options_by_id[$article->id];

                if ( ! empty($article->title))
                {
                    $option->setLabel($article->title);
                }

                $options->addItem($option);
            }

            return $options;
        }

        private function orderArticles(&$articles, $sort_by, $sort_direction, $options)
        {
            if ($sort_by === 'label')
            {
                Helper::orderArticles($articles, 'title', $sort_direction);

                return;
            }

            $ordered = [];

            foreach ($articles as $article)
            {
                $order = ($sort_direction === 'DESC')
                    ? (10000000 - $options[$article->id]->getData()->count)
                    : str_pad($options[$article->id]->getData()->count, 8, '0', STR_PAD_LEFT);

                $ordered[$order . '.' . $article->title . '.' . $article->id] = $article;
            }

            ksort($ordered);

            $articles = array_values($ordered);
        }
    }
}
