<?php
/**
 * @package         Articles Field
 * @version         4.4.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die();

use Joomla\CMS\Router\Route as JRoute;
use Joomla\Component\Content\Site\Helper\RouteHelper as JContentHelperRoute;

/*
 * @var array  $displayData
 * @var object $article
 * @var object $settings
 */
extract($displayData);

$title = htmlentities($article->title);

if ($settings->link_title)
{
    $slug = $article->alias ? ($article->id . ':' . $article->alias) : $article->id;
    $link = JRoute::link('site', JContentHelperRoute::getArticleRoute($slug, $article->catid, $article->language));

    $title = '<a href="' . $link . '">' . $title . '</a>';
}

echo $title;
