<?php
/**
 * @package         Articles Field
 * @version         4.4.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die();

use Joomla\CMS\Language\Text as JText;
use Joomla\CMS\Router\Route as JRoute;
use Joomla\Component\Content\Site\Helper\RouteHelper as JContentHelperRoute;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper as JFieldsHelper;
use RegularLabs\Plugin\Fields\Articles\Helper;

/*
 * @var array  $displayData
 * @var object $article
 * @var object $settings
 */
extract($displayData);

$title = htmlentities($article->title);

if ($settings->link_title)
{
    $slug = $article->alias ? ($article->id . ':' . $article->alias) : $article->id;
    $link = JRoute::link('site', JContentHelperRoute::getArticleRoute($slug, $article->catid, $article->language));

    $title = '<a href="' . $link . '">' . $title . '</a>';
}

// No custom field found. Just return title
if (empty($settings->custom_field))
{
    echo $title;

    return;
}

$fields = JFieldsHelper::getFields('com_content.article', $article);

// No custom fields found. Just return title
if (empty($fields))
{
    return $title;
}

foreach ($fields as $field)
{
    if ($field->id != $settings->custom_field)
    {
        continue;
    }

    // field has no value
    if (empty($field->value))
    {
        break;
    }

    Helper::prepareCustomField('com_content.article', $article, $field);

    echo JText::sprintf('FLDA_OUTPUT_TITLE_CUSTOM_FIELD', $title, $field->value);

    return;
}

// No custom field found. Just return title
echo $title;
