<?php
/**
 * @package         Articles Field
 * @version         4.4.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Plugin\Fields\Articles;

defined('_JEXEC') or die();

use Joomla\CMS\Factory as JFactory;
use RegularLabs\Library\ArrayHelper as RL_Array;
use RegularLabs\Library\DB as RL_DB;
use RegularLabs\Library\Input as RL_Input;

class Filters
{
    private $db;
    private $form;
    private $params;

    public function __construct($params, $form = null)
    {
        $this->params = $params;
        $this->form   = $form;
        $this->db     = JFactory::getDbo();
    }

    public function addToQuery(&$query)
    {
        $this->addCategoriesToQuery($query);
    }

    public function get()
    {
        $filters = [];

        if ($this->params->get('filter_categories'))
        {
            $categories = RL_Array::toArray($this->params->get('categories'));

            if ($this->params->get('filter_categories') === 'current')
            {
                $categories = [$this->getCurrentCategoryId()];
            }

            $filters['filter_categories'] = true;

            $filters['categories']              = $categories;
            $filters['categories_inc_children'] = $this->params->get('categories_inc_children');
        }


        return $filters;
    }

    public function getCategories()
    {
        if ( ! $this->params->get('filter_categories'))
        {
            return [];
        }

        if ($this->params->get('filter_categories') === 'current')
        {
            return [$this->getCurrentCategoryId()];
        }

        $categories = (array) $this->params->get('categories', []);

        if (empty($categories))
        {
            return [];
        }

        $inc_children = $this->params->get('categories_inc_children');

        if ( ! $inc_children)
        {
            return $categories;
        }

        $children = $this->getCategoriesChildIds($categories);

        if ($inc_children == 2)
        {
            return $children;
        }

        return [...$categories, ...$children];
    }

    public function getCurrentArticleId(): int
    {
        if (
            RL_Input::getCmd('option') != 'com_content'
            || ! in_array(RL_Input::getCmd('view'), ['form', 'article'])
            || ! in_array(RL_Input::getCmd('layout'), ['edit', 'modal'])
        )
        {
            return 0;
        }

        if ($this->form && $this->form->getValue('id'))
        {
            return (int) $this->form->getValue('id');
        }

        return RL_Input::getInt('id');
    }

    private function addCategoriesToQuery(&$query)
    {
        $categories = $this->getCategories();

        if (empty($categories))
        {
            return $categories;
        }

        $query->where(RL_DB::is('a.catid', $categories));

        return $categories;
    }

    private function addCustomFieldsToQuery(&$query)
    {
    }

    private function addTagsToQuery(&$query)
    {
    }

    private function addUsersToQuery(&$query)
    {
    }

    private function filterDownArticlesByCustomFields(&$ids, $id, $value)
    {
    }

    private function getArticlesByCustomFields()
    {
    }

    private function getCategoriesChildIds($categories = [])
    {
        $children = [];

        $query = RL_DB::getQuery()
            ->select('category.id')
            ->from(RL_DB::quoteName('#__categories', 'category'))
            ->where('category.extension = ' . RL_DB::quote('com_content'))
            ->where('category.published = 1');

        while ( ! empty($categories))
        {
            $query->clear('where')
                ->where(RL_DB::is('category.parent_id', $categories));
            $this->db->setQuery($query);
            $categories = $this->db->loadColumn();

            $children = [...$children, ...$categories];
        }

        return $children;
    }

    private function getCurrentLanguage(): string
    {
    }

    private function getCurrentCategoryLanguage(): string
    {
    }

    private function getCurrentArticleLanguage(): string
    {
    }

    private function getCurrentCategoryId(): int
    {
        if ($this->form && $this->form->getValue('catid'))
        {
            return (int) $this->form->getValue('catid');
        }

        $view = RL_Input::getCmd('view');

        if ($view == 'category')
        {
            return RL_Input::getInt('id');
        }

        $id = $this->getCurrentArticleId();

        if ( ! $id)
        {
            return 0;
        }

        $query = RL_DB::getQuery()
            ->select('content.catid')
            ->from(RL_DB::quoteName('#__content', 'content'))
            ->where('content.id = ' . $id);
        $this->db->setQuery($query);

        return (int) $this->db->loadResult();
    }

    private function getTags()
    {
    }

    private function getTagsChildIds($tags = [])
    {
    }

    private function getUsers()
    {
    }
}
