<?php
/**
 * @package         Articles Field
 * @version         4.4.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Plugin\Fields\Articles\Form\Field;

defined('_JEXEC') or die();

use Joomla\CMS\HTML\HTMLHelper as JHtml;
use Joomla\CMS\Language\Text as JText;
use Joomla\Registry\Registry;
use RegularLabs\Library\ArrayHelper as RL_Array;
use RegularLabs\Library\DB as RL_DB;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Form\Form as RL_Form;
use RegularLabs\Library\Form\FormField as RL_Field;
use RegularLabs\Library\Parameters as RL_Parameters;
use RegularLabs\Plugin\Fields\Articles\Filters;
use RegularLabs\Plugin\Fields\Articles\Helper;

class ArticlesField extends RL_Field
{
    protected function getInput()
    {
        $this->params = $this->element->attributes();

        $plugin_params = RL_Parameters::getPlugin('articles', 'fields');

        if ( ! is_array($this->value))
        {
            $this->value = explode(',', $this->value);
        }

        $attributes = [
            'fieldtype'            => 'articles',
            'multiple'             => $this->get('multiple', $plugin_params->multiple),
            'currentid'            => $this->getCurrentArticleId(),
            'ordering'             => $this->get('articles_ordering', 'title'),
            'ordering_direction'   => $this->get('articles_ordering_direction', 'ASC'),
            'ordering_2'           => $this->get('articles_ordering_2', 'created'),
            'ordering_direction_2' => $this->get('articles_ordering_direction_2', 'DESC'),
            'grouping'             => $this->get('articles_grouping', ''),
            'show_category'        => $this->get('show_category', '1'),
            'show_unpublished'     => $this->get('show_unpublished', '1'),
        ];

        $filters = $this->getFilters();

        $attributes = [...$attributes, ...$filters];

        $this->attributes = new Registry($attributes);


        // Fix for subform fields which doesn't show the dropdown select list properly
        RL_Document::styleDeclaration(
            '.table-responsive {overflow-x: visible;}'
        );

        return RL_Form::selectListAjax(
            $this::class,
            $this->name,
            $this->value,
            $this->id,
            $attributes
        );
        //
        //        return RL_Form::selectlist(
        //            $options,
        //            $this->name,
        //            $this->value,
        //            $this->id,
        //            [
        //                'size'     => $this->attributes->get('size'),
        //                'multiple' => $this->attributes->get('multiple'),
        //            ]);
    }

    protected function getListOptions(array $attributes): int|array
    {
        $this->attributes = new Registry($attributes);

        return $this->getOptions();
    }

    protected function getOptions()
    {
        $query = $this->db->getQuery(true)
            ->select('COUNT(*)')
            ->from($this->db->quoteName('#__content', 'a'))
            ->where('a.access > -1');

        $filters = new Filters($this->attributes, $this->form);
        $filters->addToQuery($query);

        if ($this->max_list_count)
        {
            $this->db->setQuery($query);
            $total = $this->db->loadResult();

            if ($total > $this->max_list_count)
            {
                return -1;
            }
        }

        $categories = $filters->getCategories();

        $primary_ordering    = $this->attributes->get('ordering', 'title');
        $primary_direction   = $this->attributes->get('ordering_direction', 'ASC');
        $secondary_ordering  = $this->attributes->get('ordering_2', 'created');
        $secondary_direction = $this->attributes->get('ordering_direction_2', 'DESC');

        $ordering              = Helper::getFullOrdering($primary_ordering, $primary_direction, $secondary_ordering, $secondary_direction);
        $place_selected_at_top = false;

        if ($ordering == 'none')
        {
            $ordering              = 'a.title ASC';
            $place_selected_at_top = true;
        }

        $grouping      = $this->attributes->get('grouping', '');
        $show_category = $this->attributes->get('show_category', 1) && count($categories) != 1;
        $extras        = ['unpublished', 'language'];

        $query->clear('select')
            ->select('a.id, a.title as name, a.language, a.state as published')
            ->join('LEFT', $this->db->quoteName('#__categories', 'c') . ' ON c.id = a.catid');

        if (
            $show_category
        )
        {
            $query->select(['a.catid', 'c.title as cat']);
        }

        if ($show_category && $grouping != 'category')
        {
            $extras[] = 'cat';
        }

        if (RL_Document::isAdmin())
        {
            $extras[] = 'id';
        }


        $query->where(RL_DB::is('a.state', [0, 1]));

        if ( ! $this->attributes->get('show_unpublished', 1))
        {
            RL_DB::addArticleIsPublishedFilters($query);
        }

        $ordering = trim($ordering, ', ');

        if ($ordering)
        {
            $query->order($ordering);
        }

        $this->db->setQuery($query);
        $list = $this->db->loadObjectList('id');

        if ($place_selected_at_top && ! empty($this->value))
        {
            $selected = [];
            foreach ($this->value as $value)
            {
                if (isset($list[$value]))
                {
                    $selected[$value] = $list[$value];
                    unset($list[$value]);
                }
            }

            $list = $selected + $list;
        }

        switch ($grouping)
        {

            default:
                $options = $this->getOptionsByList($list, $extras);
                break;
        }

        $currentid = $this->attributes->get('currentid');

        if (isset($options[$currentid]) && isset($options[$currentid]->text))
        {
            $options[$currentid]->disable = true;
            $options[$currentid]->text    .= ' (' . JText::_('RL_CURRENT') . ')';
        }

        if ($this->attributes->get('multiple'))
        {
            return $options;
        }


        array_unshift($options, JHtml::_('select.option', '-', '&nbsp;', 'value', 'text', true));
        array_unshift($options, JHtml::_('select.option', '', '- ' . JText::_('Select Item') . ' -'));

        return $options;
    }

    private function flattenGroups($groups, $level = 0)
    {
    }

    private function flattenOptions($options)
    {
    }

    private function getCurrentArticleId()
    {
        $filters = new Filters($this, $this->form);

        return $filters->getCurrentArticleId();
    }

    private function getFilters()
    {
        $filters = new Filters($this, $this->form);

        return $filters->get();
    }

    private function getOptionsByListGroupedByCategory($list, $extras = [])
    {
    }
}
