<?php
/**
 * @package         Articles Field
 * @version         4.4.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Plugin\Fields\Articles\Form\Field;

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper as JHtml;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper as JFieldsHelper;
use RegularLabs\Library\Form\Form as RL_Form;
use RegularLabs\Library\Form\FormField as RL_Field;

class ArticlesFieldsField extends RL_Field
{
    protected function getInput()
    {
        $this->params = $this->element->attributes();

        if ( ! is_array($this->value))
        {
            $this->value = explode(',', $this->value);
        }

        $options = $this->getOptions();

        return RL_Form::selectlist(
            $options,
            $this->name,
            $this->value,
            $this->id,
            ['multiple' => true]
        );
    }

    protected function getOptions()
    {
        $options = parent::getOptions();

        $fields = JFieldsHelper::getFields('com_content.article', null, false, null, true);

        foreach ($fields as $field)
        {
            if ($field->type != 'articles')
            {
                continue;
            }

            $options[] = JHtml::_('select.option', $field->id, $field->title);
        }

        // Sorting the fields based on the text which is displayed
        usort(
            $options,
            fn($a, $b) => strcmp($a->text, $b->text)
        );

        return $options;
    }
}
