<?php
/**
 * @package         Articles Field
 * @version         4.4.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Plugin\Fields\Articles\Form\Field;

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper as JHtml;
use Joomla\CMS\Language\Text as JText;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper as JFieldsHelper;
use RegularLabs\Library\ArrayHelper as RL_Array;
use RegularLabs\Library\Form\Form as RL_Form;
use RegularLabs\Library\Form\FormField as RL_Field;

class CustomFieldField extends RL_Field
{
    protected function getInput()
    {
        $this->params = $this->element->attributes();

        if ( ! is_array($this->value))
        {
            $this->value = explode(',', $this->value);
        }

        $options = $this->getOptions();

        return RL_Form::selectlist(
            $options,
            $this->name,
            $this->value,
            $this->id
        );
    }

    protected function getOptions()
    {
        $excludes = RL_Array::toArray($this->get('exclude'));

        $options = parent::getOptions();

        $fields = JFieldsHelper::getFields('com_content.article');

        foreach ($fields as $field)
        {
            if (in_array($field->type, $excludes))
            {
                continue;
            }

            $options[] = JHtml::_('select.option', $field->id, $field->title);
        }

        if ( ! empty($options))
        {
            array_unshift($options, JHtml::_('select.option', '-', '&nbsp;', 'value', 'text', true));
            array_unshift($options, JHtml::_('select.option', '', '- ' . JText::_('JSELECT') . ' -', 'value', 'text', false));
        }

        return $options;
    }
}
